/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.CustomCardMaker.structure;

import LegendaryCardMaker.CustomCardMaker.ALIGNMENT;
import LegendaryCardMaker.CustomCardMaker.CustomCardMaker;
import LegendaryCardMaker.CustomCardMaker.structure.CustomElement;
import LegendaryCardMaker.CustomCardMaker.structure.CustomProperties;
import LegendaryCardMaker.CustomCardMaker.structure.ElementBackgroundImage;
import LegendaryCardMaker.CustomCardMaker.structure.ElementCardName;
import LegendaryCardMaker.CustomCardMaker.structure.ElementIcon;
import LegendaryCardMaker.CustomCardMaker.structure.ElementImage;
import LegendaryCardMaker.CustomCardMaker.structure.ElementProperty;
import LegendaryCardMaker.CustomCardMaker.structure.ElementText;
import LegendaryCardMaker.CustomCardMaker.structure.ElementTextArea;
import LegendaryCardMaker.Icon;
import LegendaryCardMaker.LegendaryCardMaker;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CustomTemplate
implements Cloneable {
    public String templateName;
    public String templateDisplayName;
    public String tab = "Custom";
    public HashMap<String, CustomElement> elementsHash = new HashMap();
    public List<CustomElement> elements = new ArrayList<CustomElement>();

    public void addElement(CustomElement element) {
        this.elementsHash.put(element.name, element);
        this.elements.add(element);
    }

    public static CustomTemplate parseCustomTemplate(String templateFolder, String templateName) {
        CustomTemplate t = new CustomTemplate();
        try {
            File fXmlFile = new File(String.valueOf(templateFolder) + File.separator + templateName + File.separator + "template.xml");
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            if (doc.hasChildNodes() && doc.getChildNodes().item(0).hasChildNodes()) {
                NodeList nodeList = doc.getChildNodes().item(0).getChildNodes();
                int count = 0;
                while (count < nodeList.getLength()) {
                    CustomElement element;
                    Node node = nodeList.item(count);
                    LegendaryCardMaker.debug("Processing: " + node.getNodeName());
                    if (node.getNodeName().equals("template")) {
                        if (node.getAttributes().getNamedItem("name") != null) {
                            t.templateName = node.getAttributes().getNamedItem("name").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("displayname") != null) {
                            t.templateDisplayName = node.getAttributes().getNamedItem("displayname").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("tab") != null) {
                            t.tab = node.getAttributes().getNamedItem("tab").getNodeValue();
                        }
                    }
                    if (node.getNodeName().equals("cardsize")) {
                        if (node.getAttributes().getNamedItem("cardwidth") != null) {
                            CustomCardMaker.cardWidth = Integer.parseInt(node.getAttributes().getNamedItem("cardwidth").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("cardheight") != null) {
                            CustomCardMaker.cardHeight = Integer.parseInt(node.getAttributes().getNamedItem("cardheight").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("dpi") != null) {
                            CustomCardMaker.dpi = Integer.parseInt(node.getAttributes().getNamedItem("dpi").getNodeValue());
                        }
                    }
                    if (node.getNodeName().equals("bgimage")) {
                        element = new ElementBackgroundImage();
                        element.template = t;
                        if (node.getAttributes().getNamedItem("name") != null) {
                            element.name = node.getAttributes().getNamedItem("name").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("path") != null) {
                            element.path = node.getAttributes().getNamedItem("path").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("allowchange") != null) {
                            element.allowChange = Boolean.parseBoolean(node.getAttributes().getNamedItem("allowchange").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("x") != null) {
                            element.x = Integer.parseInt(node.getAttributes().getNamedItem("x").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("y") != null) {
                            element.y = Integer.parseInt(node.getAttributes().getNamedItem("y").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("maxwidth") != null) {
                            element.maxWidth = Integer.parseInt(node.getAttributes().getNamedItem("maxwidth").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("maxheight") != null) {
                            element.maxHeight = Integer.parseInt(node.getAttributes().getNamedItem("maxheight").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("zoomable") != null) {
                            element.zoomable = Boolean.parseBoolean(node.getAttributes().getNamedItem("zoomable").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("fullsize") != null) {
                            element.fullSize = Boolean.parseBoolean(node.getAttributes().getNamedItem("fullsize").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("templatefile") != null) {
                            element.templateFile = Boolean.parseBoolean(node.getAttributes().getNamedItem("templatefile").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("visible") != null) {
                            element.visible = Boolean.parseBoolean(node.getAttributes().getNamedItem("visible").getNodeValue());
                        }
                        t.addElement(element);
                    }
                    if (node.getNodeName().equals("icon")) {
                        ElementIcon elementIcon = new ElementIcon();
                        elementIcon.template = t;
                        if (node.getAttributes().getNamedItem("name") != null) {
                            elementIcon.name = node.getAttributes().getNamedItem("name").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("defaultvalue") != null) {
                            elementIcon.defaultValue = Icon.valueOf(node.getAttributes().getNamedItem("defaultvalue").getNodeValue().toUpperCase());
                        }
                        if (node.getAttributes().getNamedItem("icontype") != null) {
                            elementIcon.iconType = Icon.ICON_TYPE.valueOf(node.getAttributes().getNamedItem("icontype").getNodeValue().toUpperCase());
                        }
                        if (node.getAttributes().getNamedItem("allowchange") != null) {
                            elementIcon.allowChange = Boolean.parseBoolean(node.getAttributes().getNamedItem("allowchange").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("optional") != null) {
                            elementIcon.optional = Boolean.parseBoolean(node.getAttributes().getNamedItem("optional").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("x") != null) {
                            elementIcon.x = Integer.parseInt(node.getAttributes().getNamedItem("x").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("y") != null) {
                            elementIcon.y = Integer.parseInt(node.getAttributes().getNamedItem("y").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("maxwidth") != null) {
                            elementIcon.maxWidth = Integer.parseInt(node.getAttributes().getNamedItem("maxwidth").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("maxheight") != null) {
                            elementIcon.maxHeight = Integer.parseInt(node.getAttributes().getNamedItem("maxheight").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("drawunderlay") != null) {
                            elementIcon.drawUnderlay = Boolean.parseBoolean(node.getAttributes().getNamedItem("drawunderlay").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("blurradius") != null) {
                            elementIcon.blurRadius = Integer.parseInt(node.getAttributes().getNamedItem("blurradius").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("bluedouble") != null) {
                            elementIcon.blurDouble = Boolean.parseBoolean(node.getAttributes().getNamedItem("bluedouble").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("blurexpand") != null) {
                            elementIcon.blurExpand = Integer.parseInt(node.getAttributes().getNamedItem("blurexpand").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("blurcolour") != null) {
                            elementIcon.blurColour = Color.decode(node.getAttributes().getNamedItem("blurcolour").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("visible") != null) {
                            elementIcon.visible = Boolean.parseBoolean(node.getAttributes().getNamedItem("visible").getNodeValue());
                        }
                        t.addElement(elementIcon);
                    }
                    if (node.getNodeName().equals("image")) {
                        element = new ElementImage();
                        ((ElementImage)element).template = t;
                        if (node.getAttributes().getNamedItem("name") != null) {
                            ((ElementImage)element).name = node.getAttributes().getNamedItem("name").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("path") != null) {
                            ((ElementImage)element).path = node.getAttributes().getNamedItem("path").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("allowchange") != null) {
                            ((ElementImage)element).allowChange = Boolean.parseBoolean(node.getAttributes().getNamedItem("allowchange").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("x") != null) {
                            ((ElementImage)element).x = Integer.parseInt(node.getAttributes().getNamedItem("x").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("y") != null) {
                            ((ElementImage)element).y = Integer.parseInt(node.getAttributes().getNamedItem("y").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("maxwidth") != null) {
                            ((ElementImage)element).maxWidth = Integer.parseInt(node.getAttributes().getNamedItem("maxwidth").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("maxheight") != null) {
                            ((ElementImage)element).maxHeight = Integer.parseInt(node.getAttributes().getNamedItem("maxheight").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("zoomable") != null) {
                            ((ElementImage)element).zoomable = Boolean.parseBoolean(node.getAttributes().getNamedItem("zoomable").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("fullsize") != null) {
                            ((ElementImage)element).fullSize = Boolean.parseBoolean(node.getAttributes().getNamedItem("fullsize").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("templatefile") != null) {
                            ((ElementImage)element).templateFile = Boolean.parseBoolean(node.getAttributes().getNamedItem("templatefile").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("visible") != null) {
                            ((ElementImage)element).visible = Boolean.parseBoolean(node.getAttributes().getNamedItem("visible").getNodeValue());
                        }
                        t.addElement(element);
                    }
                    if (node.getNodeName().equals("property")) {
                        element = new ElementProperty();
                        ((ElementProperty)element).template = t;
                        if (node.getAttributes().getNamedItem("name") != null) {
                            ((ElementProperty)element).name = node.getAttributes().getNamedItem("name").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("defaultvalue") != null) {
                            ((ElementProperty)element).defaultValue = node.getAttributes().getNamedItem("defaultvalue").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("property") != null) {
                            ((ElementProperty)element).property = CustomProperties.valueOf(node.getAttributes().getNamedItem("property").getNodeValue().toUpperCase());
                        }
                        if (node.getAttributes().getNamedItem("visible") != null) {
                            ((ElementProperty)element).visible = Boolean.parseBoolean(node.getAttributes().getNamedItem("visible").getNodeValue());
                        }
                        t.addElement(element);
                    }
                    if (node.getNodeName().equals("text")) {
                        element = new ElementText();
                        ((ElementText)element).template = t;
                        if (node.getAttributes().getNamedItem("name") != null) {
                            ((ElementText)element).name = node.getAttributes().getNamedItem("name").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("defaultvalue") != null) {
                            ((ElementText)element).defaultValue = node.getAttributes().getNamedItem("defaultvalue").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("linkedelement") != null) {
                            ((ElementText)element).linkedElement = t.elementsHash.get(node.getAttributes().getNamedItem("linkedelement").getNodeValue());
                            if (((ElementText)element).linkedElement != null) {
                                ((ElementText)element).linkedElement.childElements.add(element);
                            }
                        }
                        if (node.getAttributes().getNamedItem("allowchange") != null) {
                            ((ElementText)element).allowChange = Boolean.parseBoolean(node.getAttributes().getNamedItem("allowchange").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("x") != null) {
                            ((ElementText)element).x = Integer.parseInt(node.getAttributes().getNamedItem("x").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("y") != null) {
                            ((ElementText)element).y = Integer.parseInt(node.getAttributes().getNamedItem("y").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("colour") != null) {
                            ((ElementText)element).colour = Color.decode(node.getAttributes().getNamedItem("colour").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("drawunderlay") != null) {
                            ((ElementText)element).drawUnderlay = Boolean.parseBoolean(node.getAttributes().getNamedItem("drawunderlay").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("blurradius") != null) {
                            ((ElementText)element).blurRadius = Integer.parseInt(node.getAttributes().getNamedItem("blurradius").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("bluedouble") != null) {
                            ((ElementText)element).blurDouble = Boolean.parseBoolean(node.getAttributes().getNamedItem("bluedouble").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("blurexpand") != null) {
                            ((ElementText)element).blurExpand = Integer.parseInt(node.getAttributes().getNamedItem("blurexpand").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("blurcolour") != null) {
                            ((ElementText)element).blurColour = Color.decode(node.getAttributes().getNamedItem("blurcolour").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("textsize") != null) {
                            ((ElementText)element).textSize = Integer.parseInt(node.getAttributes().getNamedItem("textsize").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("uppercase") != null) {
                            ((ElementText)element).uppercase = Boolean.parseBoolean(node.getAttributes().getNamedItem("uppercase").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("fontname") != null) {
                            ((ElementText)element).fontName = node.getAttributes().getNamedItem("fontname").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("textsize") != null) {
                            ((ElementText)element).textSize = Integer.parseInt(node.getAttributes().getNamedItem("textsize").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("alignment") != null) {
                            ((ElementText)element).alignment = ALIGNMENT.valueOf(node.getAttributes().getNamedItem("alignment").getNodeValue().toUpperCase());
                        }
                        if (node.getAttributes().getNamedItem("visible") != null) {
                            ((ElementText)element).visible = Boolean.parseBoolean(node.getAttributes().getNamedItem("visible").getNodeValue());
                        }
                        t.addElement(element);
                    }
                    if (node.getNodeName().equals("cardname")) {
                        element = new ElementCardName();
                        ((ElementCardName)element).template = t;
                        if (node.getAttributes().getNamedItem("name") != null) {
                            ((ElementCardName)element).name = node.getAttributes().getNamedItem("name").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("defaultvalue") != null) {
                            ((ElementCardName)element).defaultValue = node.getAttributes().getNamedItem("defaultvalue").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("includesubname") != null) {
                            ((ElementCardName)element).includeSubname = Boolean.parseBoolean(node.getAttributes().getNamedItem("includesubname").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("subnametext") != null) {
                            ((ElementCardName)element).subnameText = node.getAttributes().getNamedItem("subnametext").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("subnameeditable") != null) {
                            ((ElementCardName)element).subnameEditable = Boolean.parseBoolean(node.getAttributes().getNamedItem("subnameeditable").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("allowchange") != null) {
                            ((ElementCardName)element).allowChange = Boolean.parseBoolean(node.getAttributes().getNamedItem("allowchange").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("x") != null) {
                            ((ElementCardName)element).x = Integer.parseInt(node.getAttributes().getNamedItem("x").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("y") != null) {
                            ((ElementCardName)element).y = Integer.parseInt(node.getAttributes().getNamedItem("y").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("colour") != null) {
                            ((ElementCardName)element).colour = Color.decode(node.getAttributes().getNamedItem("colour").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("drawunderlay") != null) {
                            ((ElementCardName)element).drawUnderlay = Boolean.parseBoolean(node.getAttributes().getNamedItem("drawunderlay").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("blurradius") != null) {
                            ((ElementCardName)element).blurRadius = Integer.parseInt(node.getAttributes().getNamedItem("blurradius").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("bluedouble") != null) {
                            ((ElementCardName)element).blurDouble = Boolean.parseBoolean(node.getAttributes().getNamedItem("bluedouble").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("blurexpand") != null) {
                            ((ElementCardName)element).blurExpand = Integer.parseInt(node.getAttributes().getNamedItem("blurexpand").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("highlightcolour") != null) {
                            ((ElementCardName)element).highlightColour = Color.decode(node.getAttributes().getNamedItem("highlightcolour").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("uppercase") != null) {
                            ((ElementCardName)element).uppercase = Boolean.parseBoolean(node.getAttributes().getNamedItem("uppercase").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("fontname") != null) {
                            ((ElementCardName)element).fontName = node.getAttributes().getNamedItem("fontname").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("textsize") != null) {
                            ((ElementCardName)element).textSize = Integer.parseInt(node.getAttributes().getNamedItem("textsize").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("subnamesize") != null) {
                            ((ElementCardName)element).subnameSize = Integer.parseInt(node.getAttributes().getNamedItem("subnamesize").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("alignment") != null) {
                            ((ElementCardName)element).alignment = ALIGNMENT.valueOf(node.getAttributes().getNamedItem("alignment").getNodeValue().toUpperCase());
                        }
                        if (node.getAttributes().getNamedItem("highlight") != null) {
                            ((ElementCardName)element).highlight = ElementCardName.HIGHLIGHT.valueOf(node.getAttributes().getNamedItem("highlight").getNodeValue().toUpperCase());
                        }
                        if (node.getAttributes().getNamedItem("visible") != null) {
                            ((ElementCardName)element).visible = Boolean.parseBoolean(node.getAttributes().getNamedItem("visible").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("subnamegap") != null) {
                            ((ElementCardName)element).subnameGap = Integer.parseInt(node.getAttributes().getNamedItem("subnamegap").getNodeValue());
                        }
                        t.addElement(element);
                    }
                    if (node.getNodeName().equals("textarea")) {
                        element = new ElementTextArea();
                        ((ElementTextArea)element).template = t;
                        if (node.getAttributes().getNamedItem("name") != null) {
                            ((ElementTextArea)element).name = node.getAttributes().getNamedItem("name").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("defaultvalue") != null) {
                            ((ElementTextArea)element).defaultValue = node.getAttributes().getNamedItem("defaultvalue").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("allowchange") != null) {
                            ((ElementTextArea)element).allowChange = Boolean.parseBoolean(node.getAttributes().getNamedItem("allowchange").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("colour") != null) {
                            ((ElementTextArea)element).colour = Color.decode(node.getAttributes().getNamedItem("colour").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("fontname") != null) {
                            ((ElementTextArea)element).fontName = node.getAttributes().getNamedItem("fontname").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("fontnamebold") != null) {
                            ((ElementTextArea)element).fontNameBold = node.getAttributes().getNamedItem("fontnamebold").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("textsize") != null) {
                            ((ElementTextArea)element).textSize = Integer.parseInt(node.getAttributes().getNamedItem("textsize").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("textsizebold") != null) {
                            ((ElementTextArea)element).textSizeBold = Integer.parseInt(node.getAttributes().getNamedItem("textsizebold").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("alignmenthorizontal") != null) {
                            ((ElementTextArea)element).alignmentHorizontal = ALIGNMENT.valueOf(node.getAttributes().getNamedItem("alignmenthorizontal").getNodeValue().toUpperCase());
                        }
                        if (node.getAttributes().getNamedItem("alignmentvertical") != null) {
                            ((ElementTextArea)element).alignmentVertical = ALIGNMENT.valueOf(node.getAttributes().getNamedItem("alignmentvertical").getNodeValue().toUpperCase());
                        }
                        if (node.getAttributes().getNamedItem("rectxarray") != null) {
                            ((ElementTextArea)element).rectXArray = node.getAttributes().getNamedItem("rectxarray").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("rectyarray") != null) {
                            ((ElementTextArea)element).rectYArray = node.getAttributes().getNamedItem("rectyarray").getNodeValue();
                        }
                        if (node.getAttributes().getNamedItem("debug") != null) {
                            ((ElementTextArea)element).debug = Boolean.parseBoolean(node.getAttributes().getNamedItem("debug").getNodeValue());
                        }
                        if (node.getAttributes().getNamedItem("visible") != null) {
                            ((ElementTextArea)element).visible = Boolean.parseBoolean(node.getAttributes().getNamedItem("visible").getNodeValue());
                        }
                        t.addElement(element);
                    }
                    ++count;
                }
            }
            return t;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public CustomTemplate getCopy() {
        try {
            CustomTemplate template = (CustomTemplate)this.clone();
            ArrayList<CustomElement> elements = new ArrayList<CustomElement>();
            for (CustomElement e : template.elements) {
                elements.add(e.getCopy());
            }
            for (CustomElement e : elements) {
                if (e.childElements == null || e.childElements.size() <= 0) continue;
                ArrayList<CustomElement> newChildElements = new ArrayList<CustomElement>();
                for (CustomElement ce : e.childElements) {
                    for (CustomElement ne : elements) {
                        if (!ne.name.equals(ce.name)) continue;
                        newChildElements.add(ne);
                    }
                }
                e.childElements = newChildElements;
            }
            template.elements = elements;
            return template;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public CustomElement getElement(String name) {
        for (CustomElement e : this.elements) {
            if (!e.name.equals(name)) continue;
            return e;
        }
        return null;
    }

    public ElementProperty getProperty(CustomProperties property) {
        for (CustomElement ce : this.elements) {
            if (!(ce instanceof ElementProperty) || ((ElementProperty)ce).property == null || !((ElementProperty)ce).property.equals((Object)property)) continue;
            return (ElementProperty)ce;
        }
        return null;
    }
}

